﻿//////////////////////////////////////////////
// PbsEnvironmentMapFilter.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class PbsEnvironmentMapFilterData ;
	class System ;
}

namespace nkGraphics
{
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT PbsEnvironmentMapFilter final
	{
		public :

			// Constructor, destructor
			PbsEnvironmentMapFilter (System* system) noexcept ;
			~PbsEnvironmentMapFilter () ;

			// Filtering
			void requestEnvironmentMapFiltering (nkGraphics::Texture* envMap, nkGraphics::Texture* outFilteredMap, unsigned int outPixelDims = 128) ;
			void requestIrradianceComputing (nkGraphics::Texture* input, nkGraphics::Texture* output) ;

		private :

			// Fill
			void _setupData () ;

		private :

			// Attributes
			nkMemory::UniquePtr<PbsEnvironmentMapFilterData> _data ;
			System* _system ;
	} ;
}